/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class KeyLockableTile
extends class_2586 {
    private String password = null;

    public KeyLockableTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.KEY_LOCKABLE_TILE.get(), pos, state);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPassword(class_1799 stack) {
        this.setPassword(stack.method_7964().getString());
    }

    public void clearOwner() {
        this.password = null;
    }

    public static boolean isCorrectKey(class_1799 key, String password) {
        return key.method_7964().getString().equals(password);
    }

    public boolean isCorrectKey(class_1799 key) {
        return KeyLockableTile.isCorrectKey(key, this.password);
    }

    public static boolean doesPlayerHaveKeyToOpen(class_1657 player, String lockPassword, boolean feedbackMessage, @Nullable String translName) {
        KeyStatus key = ItemsUtil.hasKeyInInventory(player, lockPassword);
        if (key == KeyStatus.INCORRECT_KEY) {
            if (feedbackMessage) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.supplementaries.safe.incorrect_key"), true);
            }
            return false;
        }
        if (key == KeyStatus.CORRECT_KEY) {
            return true;
        }
        if (feedbackMessage) {
            player.method_7353((class_2561)class_2561.method_43471((String)("message.supplementaries." + translName + ".locked")), true);
        }
        return false;
    }

    public boolean handleAction(class_1657 player, class_1268 handIn, String translName) {
        if (player.method_7325()) {
            return false;
        }
        class_1799 stack = player.method_5998(handIn);
        boolean isKey = stack.method_31573(ModTags.KEY);
        if (player.method_21823() && isKey) {
            if (this.tryClearingKey(player, stack)) {
                return false;
            }
        } else if (this.password == null) {
            if (isKey) {
                this.setPassword(stack);
                player.method_7353((class_2561)class_2561.method_43469((String)"message.supplementaries.safe.assigned_key", (Object[])new Object[]{this.password}), true);
                this.field_11863.method_43128(null, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, class_3417.field_15082, class_3419.field_15245, 0.5f, 1.5f);
                return false;
            }
            return true;
        }
        return player.method_7337() || KeyLockableTile.doesPlayerHaveKeyToOpen(player, this.password, true, translName);
    }

    public boolean tryClearingKey(class_1657 player, class_1799 stack) {
        if (player.method_7337() || this.isCorrectKey(stack)) {
            this.clearOwner();
            player.method_7353((class_2561)class_2561.method_43471((String)"message.supplementaries.safe.cleared"), true);
            this.field_11863.method_43128(null, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, class_3417.field_15082, class_3419.field_15245, 0.5f, 1.5f);
            return true;
        }
        return false;
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.password = compound.method_10545("Password") ? compound.method_10558("Password") : null;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.password != null) {
            tag.method_10582("Password", this.password);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public static enum KeyStatus {
        CORRECT_KEY,
        INCORRECT_KEY,
        NO_KEY;

    }
}

